/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.placementhandlers;

import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.LecternBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LecternPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.func_177230_c() instanceof LecternBlock;
    }

    public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        itemList.add(BlockUtils.getItemStackFromBlockState((BlockState)blockState));
        LecternTileEntity lectern = LecternPlacementHandler.getLectern(blockState, tileEntityData);
        if (lectern != null && lectern.func_214046_f()) {
            itemList.add(new ItemStack((IItemProvider)Items.field_151122_aG));
        }
        return itemList;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos) {
        if (!world.func_180501_a(pos, blockState, 3)) {
            return IPlacementHandler.ActionProcessingResult.DENY;
        }
        if (tileEntityData != null) {
            PlacementHandlers.handleTileEntityPlacement((CompoundNBT)tileEntityData, (World)world, (BlockPos)pos);
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    @Nullable
    private static LecternTileEntity getLectern(@NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData) {
        TileEntity tileEntity;
        if (tileEntityData != null && (tileEntity = TileEntity.func_235657_b_((BlockState)blockState, (CompoundNBT)tileEntityData)) instanceof LecternTileEntity) {
            return (LecternTileEntity)tileEntity;
        }
        return null;
    }
}

